/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem.fru.config;

import com.ibm.hwmca.fw.service.config.ClassData;
import com.ibm.hwmca.fw.service.config.XMLMapParser;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfigParser;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruTableEntry;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLParsingException;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class EnclosureConfigParser
extends XMLMapParser {
    public static final String FEATURE_CODE = "FEATURE_CODE";
    private static final String TRACE_MASKT = "XRVFECPT";
    private static final String TRACE_MASKF = "XRVFECPF";
    private static final String TRACE_MASKD = "XRVFECPD";
    private static final String TAG_DESCRIPTIONS = "descriptions";
    private static final String TAG_ENCLOSURE_CONFIG = "enclosure-config";
    private static final String TAG_LOCATION = "location";
    private static final String TAG_LOCATIONS = "locations";
    private static final String TAG_FRU = "fru";
    private static final String TAG_DESC = "desc";
    private static final String TAG_CLASS = "class";
    private static final String TAG_PROPERTIES = "properties";
    private static final String TAG_HAS_LED = "has-LED";
    private static final String ATTRIB_SUFFIX = "suffix";
    private static final String ATTRIB_POWER_BOUNDARY = "power-boundary";
    private static final String ATTRIB_ID = "id";
    private String descPropertiesFile = null;

    public static void main(String[] args) {
        try {
            EnclosureConfigParser p = new EnclosureConfigParser();
            Map m = p.parseXML(new File(System.getProperty("CONSOLE_PATH") + "/" + args[0]));
            System.out.println("map=" + m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EnclosureConfigParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setErrorHandler(this);
    }

    public Map parseXML(String xmlFile) throws XMLParsingException {
        return this.parseXML(new File(xmlFile));
    }

    public Map parseXML(File file) throws XMLParsingException {
        Trace.trace(TRACE_MASKT, "EnclosureConfigParser parsing file: " + file);
        Map enclosureLocationsMap = null;
        try {
            EnclosureConfigParser ecp = new EnclosureConfigParser();
            this.parse(new InputSource(new FileInputStream(file)));
            Document doc = this.getDocument();
            NodeList nodeList = doc.getElementsByTagName(TAG_DESCRIPTIONS);
            if (nodeList != null && nodeList.getLength() > 0) {
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseXML: parsing descriptions properties filename");
                this.descPropertiesFile = FruConfigParser.parseDescriptionsPropertiesFileName(nodeList.item(0));
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseXML: parsing descriptions properties filename: " + this.descPropertiesFile);
            }
            if ((nodeList = doc.getElementsByTagName(TAG_LOCATIONS)) != null && nodeList.getLength() > 0) {
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseXML: parsing location defs");
                enclosureLocationsMap = this.parseLocations(nodeList.item(0));
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseXML: location defs parsed: " + enclosureLocationsMap);
            }
        }
        catch (Exception thrown) {
            Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseXML exception caught: " + thrown);
            Trace.trace(TRACE_MASKF, thrown);
            if (thrown instanceof XMLParsingException) {
                throw (XMLParsingException)thrown;
            }
            throw new XMLParsingException(thrown);
        }
        return enclosureLocationsMap;
    }

    private Map parseLocations(Node nodeToParse) throws XMLParsingException {
        HashMap<String, Object[]> locationsMap = new HashMap<String, Object[]>();
        NodeList nodes = nodeToParse.getChildNodes();
        for (int aii = 0; aii < nodes.getLength(); ++aii) {
            Node node = nodes.item(aii);
            if (node.getNodeType() != 1 || !node.getNodeName().toLowerCase().equals(TAG_LOCATION)) continue;
            String locationSuffix = node.getAttributes().getNamedItem(ATTRIB_SUFFIX).getNodeValue().toUpperCase();
            locationsMap.put(locationSuffix, this.parseLocation(node));
        }
        Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseLocations: parsed locations map: " + locationsMap);
        return locationsMap;
    }

    private Object[] parseLocation(Node nodeToParse) throws XMLParsingException {
        String val;
        boolean isPowerBoundary = false;
        Node pdn = nodeToParse.getAttributes().getNamedItem(ATTRIB_POWER_BOUNDARY);
        if (pdn != null && ((val = pdn.getNodeValue().toUpperCase()).equals("YES") || val.equals("TRUE"))) {
            isPowerBoundary = true;
        }
        NodeList nodes = nodeToParse.getChildNodes();
        ArrayList<FruTableEntry> possibleFrus = new ArrayList<FruTableEntry>(1);
        String locationSuffix = nodeToParse.getAttributes().getNamedItem(ATTRIB_SUFFIX).getNodeValue().toUpperCase();
        for (int aii = 0; aii < nodes.getLength(); ++aii) {
            Node node = nodes.item(aii);
            if (node.getNodeType() != 1 || !node.getNodeName().toLowerCase().equals(TAG_FRU)) continue;
            FruTableEntry fte = this.parseFru(node);
            fte.setPowerBoundary(isPowerBoundary);
            fte.setLocationSuffix(locationSuffix);
            possibleFrus.add(fte);
        }
        Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseLocation: parsed " + possibleFrus.size() + " <fru> tags");
        return possibleFrus.toArray();
    }

    private FruTableEntry parseFru(Node nodeToParse) throws XMLParsingException {
        FruTableEntry fruEntry = new FruTableEntry();
        ClassData classData = null;
        Map<String, String> props = null;
        Node id = nodeToParse.getAttributes().getNamedItem(ATTRIB_ID);
        if (id != null) {
            fruEntry.setId(id.getNodeValue().toUpperCase());
        }
        NodeList nodes = nodeToParse.getChildNodes();
        for (int aii = 0; aii < nodes.getLength(); ++aii) {
            Node node = nodes.item(aii);
            if (node.getNodeType() != 1) continue;
            String tag = node.getNodeName().toLowerCase();
            Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFrus:processing tag" + tag);
            if (tag.equals(TAG_CLASS)) {
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFrus:found TAG_CLASS");
                classData = new ClassData();
                classData.setClassName(EnclosureConfigParser.gatherTextContents(node));
                fruEntry.setClassData(classData);
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFru value: " + classData.getClassName());
                continue;
            }
            if (tag.equals(TAG_DESC)) {
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFrus:found TAG_DESC");
                fruEntry.setDesc(new LocalizableText(this.descPropertiesFile, EnclosureConfigParser.gatherTextContents(node)));
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFru value: " + fruEntry.getDesc());
                continue;
            }
            if (tag.equals(TAG_HAS_LED)) {
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFrus:found TAG_HAS_LED");
                String hasLed = EnclosureConfigParser.gatherTextContents(node).toUpperCase();
                boolean bhasLed = hasLed.equals("YES") || hasLed.equals("TRUE");
                fruEntry.setHasLED(bhasLed);
                Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFru value: " + fruEntry.getHasLED());
                continue;
            }
            if (!tag.equals(TAG_PROPERTIES)) continue;
            Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFrus:found TAG_PROPERTIES");
            props = ClassData.parseInputMap(node);
        }
        fruEntry.setClassData(classData);
        if (props == null) {
            props = new HashMap<String, String>();
        }
        props.put("DESC", fruEntry.getDesc());
        props.put("HAS_LED", (String)((Object)Boolean.valueOf(fruEntry.getHasLED())));
        fruEntry.setProperties(props);
        Trace.trace(TRACE_MASKF, "EnclosureConfigParser.parseFru: parsed FRU entry: " + fruEntry);
        return fruEntry;
    }
}

